# Introduction

<div align="left"><figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FKz0LhPm8JCtR5BBvhQM2%2FgeodlogoB24.png?alt=media&#x26;token=b57bafe3-0031-432c-b56f-629a2ab0a957" alt="" width="375"><figcaption></figcaption></figure></div>

### What is GEODNET

GEODNET is an acronym for Global Earth Observation Decentralized Network, and the project is run by experienced individuals in the GPS industry. It is a Web3.0 blockchain-based highly-reliable RTK (Real-Time Kinematics) Network using #DePIN (Decentralized Physical Infrastructure Network) principles. You can think of it as an advanced network combining blockchain and RTK technologies to provide precise real-time positioning data.

A permanent GNSS reference station on the GEODNET network is called a Base Station (also known as Satellite Miner). The long-term goal of the GEODNET Project is to fully cover the land surface of the Earth with 100,000 **evenly** placed Base Stations, which will form a network approximately twenty times larger than any existing Continuously Operated Reference Station (“CORS”) network.

### Why GEODNET is Game Changing&#x20;

Traditional GPS positioning often relies on signals from satellites positioned over 10,000 miles away. While this method is remarkably effective, it can sometimes result in location estimations with a margin of error spanning from a few to several dozen meters.

To address this challenge, GEODNET introduces the concept of a reference station network. These Base Stations, installed on rooftops globally, serve as nodes in the network. Through a process known as "correction streaming," the reference station network disseminates real-time correction data to nearby devices subscribed to our service. As a result, devices within approximately 20 kilometers of a reference station can achieve instant centimeter-level accuracy in positioning, akin to Real-Time Kinematic (RTK) technology but without the associated costs. In return for providing these crucial reference points, participants receive GEOD tokens as rewards.

The implications of this enhanced accuracy are profound. From smartphones navigating urban landscapes to autonomous vehicles traversing highways, high-precision location data enables increased automation and efficiency across diverse industries such as agriculture, construction, and transportation. Moreover, consumer-facing applications stand to benefit from more reliable and convenient mapping services too.

By leveraging token incentives, GEODNET encourages individuals worldwide to participate in our ambitious mission.&#x20;
