# Performance-Based Reward Rules

## What is Performance-Based Reward?

The Performance-Based Reward system was introduced and approved by [GIP6 ](https://vote.geodnet.com/proposal-list?id=GIP643631741949739805)on April 7, 2025.

The primary objective of this proposal is to enhance the overall service quality of the GEODNET network by improving station performance, minimizing downtime, and reducing signal multipath (MP). This ensures the delivery of high-quality data services to customers. The system incentivizes underperforming stations to improve while rewarding high-performing stations, promoting greater efficiency and fairness across the network.

This rule operates in conjunction with other network rules that guide GEODNET token distribution, including [token reward metrics](https://docs.geodnet.com/geod-mining/token-reward-metrics), [hex reward rules](https://docs.geodnet.com/geod-mining/hex-reward-rules), and the[ superhex multiplier](https://docs.geodnet.com/geod-console-advanced/superhex).

The Performance-Based Reward rules took effect on July 2, 2025.<br>

## Penalties & Bonus Rewards

### Penalties

Stations that do not meet performance standards will lose their rewards. These forfeited rewards will be allocated to an extra reward pool for eligible backbone stations.

* **RRR:** Stations with a two-hourly RRR < 80% will lose rewards for that period.  This applies to both NFT and non-NFT stations.
* **Multipath (MP):** Stations with MP > 0.75m will lose rewards.
* **Dual-Band:** All dual-band stations and signals will be ineligible for GEOD rewards.

### Bonus Rewards

Stations in the backbone RTK network with 7-day RRR > 99.9% are eligible to equally share the bonus reward pool. GEODNET will first build the backbone RTK network in Europe and North America, later expanding to Asia, Australia, South America, and Africa in the future.

* If a backbone station has not added a phone number and a wallet address, it will not receive any bonus rewards. The unclaimed rewards will be rolled over into the following week’s pool.
* Bonus rewards are distributed weekly.
* Rewards for qualifying backbone stations are displayed in the [**Console** ](https://console.geodnet.com/)**> Mine > Backbone Historical Rewards** section.
* Currently, only backbone stations have access to reward system statistics.
