# Track Your Station's Performance & Rewards

## Why Track Performance?

You can monitor your station’s performance and rewards on the GEODNET console. Currently, GEODNET evaluates stations performance based on key metrics to determine data quality and reward distribution. \
\
These metrics include:

* Online time
* RRR (Rolling Reward Rate)
* MP (Multipath)
* Device type (Triple-band or Dual-band)

This holistic breakdown helps station owners identify areas for improvement.<br>

## How to Track?

1. Log in to your console account and click the "Mine" tab to view your station list.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2F7mAeT1LwFThT0PVOQEtW%2F5097912f52041b534b27fb22b64f583.png?alt=media&#x26;token=ccc77d66-980d-40ad-89b8-a23a19fe2329" alt=""><figcaption></figcaption></figure>

2. Click a Miners SN to see its historical rewards.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FAcY6Dsqyt23jYOTkvzEJ%2F0fbfdc69a7d19e72e83e375d17e9391.png?alt=media&#x26;token=296bf18f-491a-47b8-9e31-0d3035661f05" alt=""><figcaption></figcaption></figure>

3. View your station's daily rewards, accumulated historical rewards, and distributed rewards to date. Extra reward may come from community events, bug compensation, etc.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2Fcgot0akGz9mLOjuifV8v%2F6b64ee22d6ca229a219e0e5ff6a558a.png?alt=media&#x26;token=478169ed-cc12-4ba5-b600-68f6a0f6eb28" alt=""><figcaption></figcaption></figure>

4. Click "Details" to view daily reward breakdowns.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2F2JOLVOLBXd8QFROM0jD1%2F2838e30b20b35b3474e515cd77af984.png?alt=media&#x26;token=2b02bdd1-202b-4285-9ed2-94ad737fa34e" alt=""><figcaption></figcaption></figure>

5. If your station's performance is below standards, relevant metrics will be highlighted in red (e.g., RRR < 80%, MP > 0.75, or Dual-band signals). Underperforming hours earn zero rewards - details in [performance-based reward rules](https://docs.geodnet.com/performance-based-reward-rules).

<div align="left"><figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FA147cDhUEFIp8fkI7bNZ%2F1751880994789.png?alt=media&#x26;token=2969d102-007c-4914-a9bc-8ac58b3505c6" alt=""><figcaption></figcaption></figure></div>

Below is an example of reward calculations.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FwKDxlqC8RCkU43CKWmfr%2F25d636913f7b467e5ea7eede82c4614.png?alt=media&#x26;token=bb906058-b9eb-4623-83c1-bc99b29bccb8" alt=""><figcaption></figcaption></figure>

## Backbone Station Bonus Rewards

1. If your station is selected as a backbone station, on your console "Mine" page, you can see the bonus reward pool, eligible number of backbone stations, and expiration time of current bonus reward cycle. **Backbone station with >99.9% RRR can earn bonus rewards.** \
   \
   Your bonus rewards = Bonus $GEOD Reward Pool / Qualifying Stations (based on final numbers before weekly reward distribution)

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FLKUF3BKkBeTNsuBVEz3a%2F45036c566784eb7afa9ce99f66ac36a.png?alt=media&#x26;token=cc03ccfb-5524-4c2c-a208-7c863a34eb8f" alt=""><figcaption></figcaption></figure>

2. View your station's backbone status on the Mine page.&#x20;

**a) Green circle + purple shield:**

Your station has been selected as a backbone station, but its RRR does not qualify for the bonus reward (7-day RRR  **≤** 99.9%).

<p align="center"><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2F0KsOfdWmHSqItwxicHQs%2Fimage.png?alt=media&#x26;token=53e2ae72-1e6d-4a75-8608-70328a931739" alt=""></p>

**b) Green circle + green shield:**&#x20;

Your station has been selected as a backbone station and qualifies for the bonus reward (7-day RRR > 99.9%).

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FinxGlL4jEtRdkCudsa92%2Fcebe550d64d47139edd63d2f57d16fe.png?alt=media&#x26;token=61c69fff-793a-489c-9c30-cb73a2a19b63" alt="" width="59"><figcaption></figcaption></figure>

3. View your "Historical Backbone Rewards" under "Historical Rewards (Last 7 Days)".

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FpFeV3APgQ3xkGEP5Y61F%2Fe18886c59f7e77a5556e12f8f2f229e.png?alt=media&#x26;token=91af08a0-94d3-4542-b4cf-6a50acd06ae9" alt=""><figcaption></figcaption></figure>
