# Tokenomics

## **Token supply and unlock schedule**

The total supply of GEOD token is 1 billion. Each wallet will adhere to its own unlocking schedule. Mined tokens will be unlocked and distributed to each miner daily. However, allocations to the team, investors, and ecosystem will undergo a multi-year unlocking process.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2Ftk71gejLmxx8f2Qso9vb%2FGeod_supply_and_unlock_schedule.png?alt=media&#x26;token=02eb8941-22cd-4264-99b4-ec9455f45092" alt="" width="452"><figcaption></figcaption></figure>

Below is the list of token address for each allocation:

Mining: [0xfa5fEd5cc2b6DD8F370651D17242C52Ed711B14F](https://polygonscan.com/token/0xac0f66379a6d7801d7726d5a943356a172549adb?a=0xfa5fed5cc2b6dd8f370651d17242c52ed711b14f)

Mining distribution wallet: 0x8FB9dd00B9a3D893dA96d444817d0b77330d5478

Ecosystem: [0x3A6906E4239F9860C81035c54198Df58D892653b](https://polygonscan.com/token/0xac0f66379a6d7801d7726d5a943356a172549adb?a=0x3a6906e4239f9860c81035c54198df58d892653b)

Team: [0xca3E874Bc4e830796d822F529C29Df30302324b2](https://polygonscan.com/token/0xac0f66379a6d7801d7726d5a943356a172549adb?a=0xca3e874bc4e830796d822f529c29df30302324b2)

Investor: [0x486559899e96981DFE55C4E6EBF5101A76BfAdfa](https://polygonscan.com/token/0xac0f66379a6d7801d7726d5a943356a172549adb?a=0x486559899e96981dfe55c4e6ebf5101a76bfadfa)

Vendor/Marketing: [0x82146cf0f350c241757660fd803c73313b06d75c](https://polygonscan.com/token/0xac0f66379a6d7801d7726d5a943356a172549adb?a=0x82146cf0f350c241757660fd803c73313b06d75c)

Public sale: [0xcEcccB3ee2C208Fb58A5a02499E97D4BF041Ff6f](https://polygonscan.com/token/0xac0f66379a6d7801d7726d5a943356a172549adb?a=0xcecccb3ee2c208fb58a5a02499e97d4bf041ff6f)

## **Earning GEOD Tokens**

GEOD tokens are earned via mining. Base rewards halve annually on June 30th, so early participation will have greater rewards.&#x20;

### Base reward

The base reward is calculated based on the Base Station's effective online time. GEOD token is rewarded on a fixed rate starting at an initial 2 GEOD/hour. The base reward will be on a yearly halving process:&#x20;

| Hourly rate | Yearly | Schedule              |
| ----------- | ------ | --------------------- |
| 2           | 17520  | July 2022 - June 2023 |
| 1           | 8760   | July 2023 - June 2024 |
| 0.5         | 4380   | July 2024 - June 2025 |
| …           | …      | …                     |

Before July 2024, miners can receive up to 48 GEOD tokens/day for triple-band Base Stations with 2x multiplier incentive (24 GEOD tokens/day for dual-band Base Stations). &#x20;

| Year                    | Token Rewards up to / Day |
| ----------------------- | ------------------------- |
| 07/01/2023 - 06/30/2024 | 48 GEOD                   |
| 07/01/2024 - 06/30/2025 | 24 GEOD                   |
| 07/01/2025 - 06/30/2026 | 12 GEOD                   |
| ...                     | ...                       |

### Actual reward

Actual reward may vary based on the data quality provided by the Base Stations. Actual reward is calculated by mutiplying the base reward by the below network reward rules:

* [Token Reward Metrics](https://docs.geodnet.com/geod-mining/token-reward-metrics)
* [Hex Reward Rules](https://docs.geodnet.com/geod-mining/hex-reward-rules)
* [SuperHex Multiplier ](https://docs.geodnet.com/geod-console-advanced/superhex)
* [Performance-Based Reward Rules](https://docs.geodnet.com/performance-based-reward-rules)
