# Location NFT

### What is GEOD Location NFT?

Other DePIN projects have struggled to create even network coverage as many blockchain and crypto enthusiasts currently live in major cities, and there are also generally fewer people in rural areas. The GEODNET Location NFT is an important tool that incentivizes even geographical network coverage. Each GEODNET Location NFT is a unique, non-fungible ERC-20 token issued on Polygon.

For reference, here’s the GEODNET Location NFT collection on Opensea: <https://opensea.io/collection/geodnet-location-nft>

## How to Obtain a Location NFT

To be eligible for a location NFT, a Base Station (Satellite Miner) must satisfy ALL of the following conditions:

1. The station is the first one in the Hex providing good data (98% RRR for 30 days).
2. There must be no other station with an NFT in the same hex as the current station.
3. The station has not received an NFT previously.&#x20;
4. The station owner has a valid Polygon wallet address in their profile.

If a station has an NFT, its reward rate is protected from the splitting of rewards within a hex. See [Hex Reward Rules](https://docs.geodnet.com/geod-mining/hex-reward-rules) for details.&#x20;

## How to Find out Location NFT ID

To check if a wallet address has a Location NFT in it, go to <https://polygonscan.com/token/0x731edd6d701d0ea6df5f900b0719697904f94f0e?a=>&#x20;

Append wallet address to the end of the link, for example: for address 0x90983A50fFaD9f4d9cD0a7623C8F96938CA097F9,

visit link:  <https://polygonscan.com/token/0x731edd6d701d0ea6df5f900b0719697904f94f0e?a=0x90983A50fFaD9f4d9cD0a7623C8F96938CA097F9>

If there is Location NFT in that wallet address, it should be displayed in the list. Click the item to show the NFT ID.&#x20;

## **Location NFT Status change and Cap**

1. Updating your wallet address with an NFT will result in losing your NFT status. You can transfer the NFT to the new wallet, but it cannot be bound to your station if another miner has claimed the NFT in your hex. If you can rebind the NFT, it will only be valid again after achieving a 98% RRR over 30 days.
2. If a station with NFT was unregistered and re-registered on GEODNET console platform, the station's data will be removed, and the station will have to start over again as a new one. The station must meet the NFT criteria again for its NFT to be valid.&#x20;
3. NFTs will be unbound for any hex change, with re-binding allowed only after achieving a 98% RRR over 30 days as per [GIP2](https://vote.geodnet.com/proposal-list?id=GIP695741716474622802).&#x20;
4. Starting 11/05/2025, [GIP8](https://vote.geodnet.com/proposal-list?id=GIP976761754520391978) is implemented. NFT rules are updated:

&#x20;NFT Acquisition Rules

* To earn or re-activate an NFT, a station must achieve a ≥98% 30-day RRR.
* If two or more stations in the same Hex meet the requirement on the same day:
  * NFT goes to the station with the highest 30-day RRR.
  * If tied, NFT goes to the station with the earliest install timestamp in that Hex.

NFT Retention Rules

* Active NFT holders must maintain a ≥80% 60-day RRR.
* Dropping below this threshold makes the NFT inactive.
* If multiple eligible stations are competing for an inactive NFT, the award process follows the acquisition rules above (highest RRR, then earliest install timestamp).

20,000 Active NFT Cap

* The number of active NFTs across the network is capped at 20,000.
* If the cap is reached, no new NFTs can be awarded, and inactive NFTs cannot be reactivated until a spot opens.
* When a spot opens:
* All stations with ≥98% 30-day RRR in eligible Hexes are considered.
* The NFT goes to the station with the oldest install timestamp in that Hex.

<br>
