# Crosschain between Polygon and Solana

Watch the [YouTube tutorial](https://www.youtube.com/watch?v=PQRmBTIF1vo\&t=6s) or follow the workflow guide below to transfer your GEOD token between Polygon and Solana.&#x20;

### GEOD Token Bridge to Solana Network Overview

Below is a diagram showing the bridge process from GEOD on Polygon to GEOD on Solana.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2Fk8rUPhyjIPpAL421fXxK%2Fimage.png?alt=media&#x26;token=08976b3f-e95d-4468-8a08-6407c887d595" alt=""><figcaption></figcaption></figure>

GEOD token address on Polygon:

<https://polygonscan.com/token/0xac0f66379a6d7801d7726d5a943356a172549adb>

GEOD token address on Solana:

<https://solscan.io/token/7JA5eZdCzztSfQbJvS8aVVxMFfd81Rs9VvwnocV1mKHu#holders>

### How to Transfer GEOD Token from Polygon to Solana

&#x20;Step 1: Visit <https://sol.geodnet.com>

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FsH8tsu6LAUu8DQ0gajd0%2Fimage.png?alt=media&#x26;token=57b2d8c1-5cf2-4c47-8407-bc66608a56a1" alt=""><figcaption></figcaption></figure>

Step 2: Connect your source wallet on Polygon.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FHuWKu07crXPN09V7JmHo%2Fimage.png?alt=media&#x26;token=08fa169f-7d96-405a-bfd1-e3db623d695b" alt=""><figcaption></figcaption></figure>

Step 3: Connect your destination wallet on Solana.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FXgTxZPPveqnZ672tkj9M%2F1837967675.jpg?alt=media&#x26;token=96f2729a-44db-47a2-afbf-38519b499086" alt="" width="543"><figcaption></figcaption></figure>

Note: You may need to confirm the connection:

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FhtI9mfSXmlb7FAsz1g7q%2Fimage.png?alt=media&#x26;token=8dc338be-2215-42d7-a0e1-18bb9f473eba" alt=""><figcaption></figcaption></figure>

Step 4: Input the amount of GEOD you wish to bridge.

**Note: In order to minimize risk and provide an opportunity for liquidity in the SPL GEOD token to grow, the transfers are limited to 10,000,000 tokens per transfer.**&#x20;

<br>

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FqOWXt74j7CLCOg01IUah%2Fimage.png?alt=media&#x26;token=44c50ed7-eea1-4205-aa7e-c1510df2d915" alt=""><figcaption></figcaption></figure>

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FZaeYAq62mNAkKH3XNeDz%2Fimage.png?alt=media&#x26;token=b4a22d90-df80-4993-9dda-65d54f83c819" alt=""><figcaption></figcaption></figure>

Step 5: Approve and confirm the transaction.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FcD26cDz3FbXx9x1vcIQ8%2Fa22184b8cb74ea878f1fa5799a2b3ef7.jpg?alt=media&#x26;token=15fcecef-ce07-47a0-a931-461c0a141faa" alt="" width="347"><figcaption></figcaption></figure>

For security, please click on the "View Details" to make sure the spender address is "**0x2006B44684b2A579466fC04FAbC5A535946bC7AB**" for V1 or "**0x6762157b73941e36cEd0AEf54614DdE545d0F990**" for V3.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2F4ErOSO2OXivid7eHLWT7%2Fimage.png?alt=media&#x26;token=f57e8557-69d2-460a-b864-f86e1387a32f" alt=""><figcaption></figcaption></figure>

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FBIKocmE7yllNI7luXHU3%2Fimage.png?alt=media&#x26;token=40f59dfb-f62e-47e6-a794-7ffd1fc25ce7" alt=""><figcaption></figcaption></figure>

The confirmation page of some wallets may look like the following. You also need to confirm whether it is the correct address.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FZJNSEShBv0d14ANTx005%2Fimage.png?alt=media&#x26;token=d141b919-861a-40a7-941d-f01a3f8c3637" alt="" width="375"><figcaption></figcaption></figure>

Click "Confirm" to continue.

Step 6: Wait for the bridge transaction to complete.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2F3EaAEXHagj3BefKu5gjW%2Fimage.png?alt=media&#x26;token=77dcb32b-e379-4bee-a8c1-9d80de4d9407" alt=""><figcaption></figcaption></figure>

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FJcHhVvoKhJcpLuHLqZcY%2Fimage.png?alt=media&#x26;token=3942f383-cf58-4ad4-a435-1c325e6ffc14" alt=""><figcaption></figcaption></figure>

The process typically takes around 2 minutes to complete. Once finished, you will see your updated balance in your Solana wallet.

### How to resume from a failed TX

If the transaction is interrupted due to network or other issues, you can resume it by clicking the “Connect source wallet” button:

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FOZWcITXscml9pQP6nuIa%2FScreenshot%202025-11-10%20at%2010.10.17%E2%80%AFPM.png?alt=media&#x26;token=3019b5af-bb2d-4852-a70f-e590a676ccd6" alt=""><figcaption></figcaption></figure>

Click on top right button:

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FQGrr2YansXSOhsYd4m2f%2FScreenshot%202025-11-10%20at%2010.11.53%E2%80%AFPM.png?alt=media&#x26;token=c7706395-1b83-4eb0-b83b-774c941602cf" alt=""><figcaption></figcaption></figure>

Click on "Resume Transaction" button:

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2Fq7fIg9SRDcgDXCpHgXxd%2FScreenshot%202025-11-10%20at%2010.13.45%E2%80%AFPM.png?alt=media&#x26;token=5f57d9e7-48cd-42db-a934-aa7c293ce65e" alt=""><figcaption></figcaption></figure>

Input your initially confirmed transaction TX hash, and the bridge transaction will automatically resume.&#x20;

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FOexSerQ9uXW8DnIhxp7U%2Fimage.png?alt=media&#x26;token=1ac8b55d-88b4-4055-86dd-f9425150a3d3" alt=""><figcaption></figcaption></figure>
