# Add GEOD Token to Your Polygon Wallet

### What is a Digital Wallet

Navigating cryptocurrency without prior experience can be bewildering, especially when terms like "tokens", "coins" and "wallets" are not clearly analogous to their real-world counterparts. The following information will help clarify how a wallet functions.

Understanding how a digital wallet functions is relatively simple: for both software and hardware wallets, the only role they have is to **store and manage your private key(s) for you**.

Software Wallet: a software wallet is a secure digital address that stores your private key(s), preventing un-authorized access to your cryptocurrency.

Hardware Wallet: a hardware wallet is a physical item, such as a USB drive or other storage device, that is designed to store your private key(s) offline.

Unlike traditional wallets, digital wallets **do not store your cryptocurrency**. Tokens are never "in your wallet", instead, they are stored on the blockchain at your address.

You can think of your address like a bank account, and your private key like a PIN. If you would like to receive money from a person or business, you would provide them with your bank account number, **but never your PIN**.

<mark style="color:red;">**\[NOTE]:**</mark> <mark style="color:red;"></mark><mark style="color:red;">GEOD Network will never ask for your private key, and anyone asking for your private key is malicious. Keep your private key(s) private to prevent any theft or malicious activity.</mark>

*Reference:* [*Understanding Crypto Wallets* ](https://know.rendernetwork.com/getting-started/what-is-a-wallet)

## Setting up your Digital Wallet

In order to use, earn, or purchase GEOD Tokens, you need to have an ERC-20 compatible wallet.

We recommend using [MetaMask](https://metamask.io/) to access GEOD network and its functions. The MetaMask wallet can be easily setup by:

1. Installing the MetaMask wallet
2. Adding GEOD as a custom token to your MetaMask wallet

### **Installing the MetaMask Wallet**

MetaMask is a browser extension currently supported by Chrome, Edge, Firefox and Brave.

Installation is simple - Go to [**metamask.io**](https://metamask.io/) and follow their installation instructions.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FBv5xN1aqG14PgsoUTAjB%2FMetaMask.jpg?alt=media&#x26;token=d5a2f31b-c6e8-40d2-93df-d26d502b3c22" alt=""><figcaption><p><em><mark style="color:orange;">Be extra careful with every click you make here - there is no “undo” button, and if you lose your wallet's private keys - your coins may be gone forever!</mark></em></p></figcaption></figure>

After installation, MetaMask will generate a private key and a recovery passphrase for you. **Write this down and store in a safe place**. Treat the recovery passphrase (and private key derived from it) as your actual wallet - anyone who knows it owns your money, so **never show it to anyone**.

If you already have a Polygon wallet with a passphrase or a private key, you can skip the creation of the new one above and import the one you already have.

### **Add GEOD as a Custom Token**&#x20;

To see your GEOD balance on MetaMask's token list on the left-side menu, you must add it as a Custom Token in your MetaMask wallet.

**Method 1:** \
Log in to your MetaMask and click "Import tokens"

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2F2LupbuQDFzV8qSBY7Q10%2F710b370a5f2b6a7592fa8bf36631671.jpg?alt=media&#x26;token=20ad5018-f147-479f-bdc2-03a2bcb81863" alt="" width="349"><figcaption></figcaption></figure>

After clicking "Import tokens", you will be taken to the page shown below where you can search for GEOD token.&#x20;

Enter "GEOD" in the search box, select "Geodnet - GEOD", and click "Next". <br>

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FCrEm6wkIvHMSS5VQg7cC%2Fimage.png?alt=media&#x26;token=fd95b907-abd4-49da-b611-83725fe7853d" alt="" width="312"><figcaption></figcaption></figure>

Click "Import" to add GEOD token as a custom token in your wallet. <br>

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2Fhup7FIfAUWoUKdssdTVF%2Fd541826b753d88331db8ad729728d97.jpg?alt=media&#x26;token=aef4bd8a-8b3c-4350-a8d6-3a2228a5f629" alt="" width="313"><figcaption></figcaption></figure>

Once the GEOD token is successfully added to your wallet, the page below will appear.&#x20;

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FBmtkF3Py0SqKqqDqUrMA%2Fd4aeb27bced3d9d5f3ee5a8c5900f64.jpg?alt=media&#x26;token=704f6b45-f46a-41d9-879b-f4c2a72ada67" alt="" width="355"><figcaption></figcaption></figure>

**Method 2:**&#x20;

To add the GEOD token, go to the[ GEODNET Token page](https://polygonscan.com/token/0xac0f66379a6d7801d7726d5a943356a172549adb) on the Polygonscan website where you see the option "Add Token to MetaMask (Web3)".

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2F7mhfWorfAte0usntm0ua%2Fpolygonscan_geod.png?alt=media&#x26;token=3593a8d4-8004-4fb3-8fc5-8e00374edff0" alt=""><figcaption><p>Click "Add Token to MetaMask"</p></figcaption></figure>

MetaMask will ask you to log in and add the suggested token. Click "Add Token" and the GEOD token with your balance will show up in your wallet.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FfSTQx4u2Uoz5u3ooW4z9%2Fmetamask_add_token.png?alt=media&#x26;token=b8d041cc-a456-4d52-b80b-d18c333c6c54" alt=""><figcaption><p>Confirm with "Add Token"</p></figcaption></figure>

### **Add Your Existing Wallets to MetaMask**

After your MetaMask wallet is set up and ready to go, you can choose to add your existing digital wallets to MetaMask. To add your existing digital wallets to MetaMask, click on the "Account" on the top and select "Add account or hardware wallet", then follow the instructions to add your other wallets.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2F10p5ZLo2Itf9EtJIZ8iR%2Fmetamask_account_info.png?alt=media&#x26;token=cfa09ec3-ebff-4ee6-abcb-bd5e87bcb2e9" alt=""><figcaption><p>Clicking on your account heading will copy the address automatically</p></figcaption></figure>

## Wallet Address Vs. Contract Address

**Wallet Address** is the unique string of characters you use to send and receive cryptocurrency. It’s like the "destination" for your crypto tokens.

Your wallet address on MetaMask can be copied directly from your account. You need to select Polygon network and add your wallet address on your Console account to receive $GEOD token rewards.

Wallet address example on Metamask app:

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2Fj76N39gAkpp0cWmLjGE4%2F1737623061429.png?alt=media&#x26;token=b17651dd-bd38-4d64-a41f-982e7fa388ae" alt=""><figcaption></figcaption></figure>

Wallet address example on Polygonscan:

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FOxZmxhGUPCxki3ytrjGP%2F1737622897963.png?alt=media&#x26;token=11a9cbef-ea96-4c7f-8ea6-41755ca14a0d" alt=""><figcaption></figcaption></figure>

**Contract Address** is like the “home” of a smart contract on the blockchain. Smart contracts are pieces of code that automatically execute actions when certain conditions are met, and the smart contract address is where that code lives.

Contract Address example on Polygonscan:&#x20;

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FmhSfmgocC2iFa8F0ZWVH%2F59ec0b6fa61d71592101aaa51d87328.png?alt=media&#x26;token=5b2b7616-b23b-4424-a562-8544f69c3151" alt=""><figcaption></figcaption></figure>

<mark style="color:red;">**\[NOTE]**</mark> <mark style="color:red;"></mark><mark style="color:red;">If the recipient is the token contract itself, those tokens will be lost forever.</mark>&#x20;

Unfortunately, due to the irreversible and unforgiving nature of blockchain transactions, there's no guaranteed way to recover funds sent to a wrong wallet address, especially when sent to contract addresses.

## Purchase GEOD Tokens

To purchase GEOD and MATIC, please carefully follow the instructions listed on each exchange, or follow instructions using [MetaMask's Swap feature](https://medium.com/metamask/introducing-metamask-swaps-84318c643785).

Please make sure you are directing funds to your MetaMask wallet address.

Once purchased, wait for the transfer to succeed and the coins should appear in your MetaMask wallet.

<mark style="color:red;">**\[NOTE]**</mark> <mark style="color:red;"></mark><mark style="color:red;">Ensure that you have enough Polygon (MATIC) to cover gas fees required for every transaction you want to execut</mark>[<mark style="color:red;">e</mark>](#user-content-fn-1)[^1]<mark style="color:red;">. You can think of the "gas fees" as a form of transaction fees on blockchain networks.</mark>&#x20;

[^1]:
