# Token Reward Metrics

### What is GNSS Signal SNR?

GEODNET adopts the GNSS signal SNR (Signal-to-Noise Ratio) on L1 as an indicator for each tracked GNSS signal quality. Please refer to the article: [Measuring GNSS Signal Strength](https://insidegnss.com/measuring-gnss-signal-strength/) for details about GNSS signal SNR. Typical GNSS L1 SNR for each satellite should range from 37-45 for an acceptable installation. <mark style="color:red;">The GNSS signals with SNR below 32 will not be used in GEODNET backend algorithm.</mark> The following screenshot is the GNSS SNR signal from one online station.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FI3wvssxMboYWhnYhLkvY%2Fimage.png?alt=media&#x26;token=194282be-3930-4162-977d-628a8b6d25b5" alt=""><figcaption></figcaption></figure>

### Token Calculation based on Satellite No. and Satellite SNR

Each satellites’ SNR (signal noise ratio) will be recorded. Effective satellite number means, only SNR ≥32 satellites will be counted.&#x20;

**Previous Reward Ratio:**&#x20;

Reward ratio = 100%, if effective satellite number ≥ 30;&#x20;

Reward ratio = 0%, if effective satellite number ≤ 20;&#x20;

Reward ratio = (30-x)/10, if effective satellite number is between 20 to 30.<br>

<mark style="color:red;">**New Reward Ratio Since Approval of GIP6 on April 7, 2025:**</mark>&#x20;

Based on discussions within the GEODNET community regarding [GIP6](https://vote.geodnet.com/proposal-list?id=GIP643631741949739805), North America has significantly fewer satellite views compared to the rest of the world. As a result, it is unfair to use a single or high satellite count as a factor in the RRR (Rolling Reward Rate) calculation for GEODNET stations. After considering all relevant factors, the reward ratio has been be adjusted globally for all stations upon the approval of GIP6 as follows:\
\
Reward ratio = 100%, if effective satellite number ≥ 29;&#x20;

Reward ratio = 0%, if effective satellite number ≤26 (<80% RRR as proposed in GIP6).&#x20;

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FO5EJdbZbhHeNkJkHkF2i%2Fimage.png?alt=media&#x26;token=ecec7d16-4781-46a9-9042-e0334fca38c3" alt=""><figcaption><p>Comparison of Reward Ratios</p></figcaption></figure>

Steps

1. Count all satellites with SNR ≥ 32
2. Display effective satellite number (SNR>32) / total satellite number
3. Calculate RRR based on effective satellite number
4. Display the RRR in the graph on [GEODNET console map](https://console.geodnet.com/map)

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FfftpoVMdoMGuCKlsyCt2%2F1751616995014.png?alt=media&#x26;token=b2bcee5d-65b1-4f92-8f34-e69be4eee18a" alt=""><figcaption></figcaption></figure>

## Reward Metrics&#x20;

Data quality is essential to the usability of GEODNET network. The GEODNET team is working hard to employ more metrics over time to improve data quality and determine the token rewards for miners. In addition to the existing metrics, we are planning to add metrics such as data shift and latency etc.&#x20;

The following table provides an overview of our reward metrics since 2022.&#x20;

<table><thead><tr><th>Value</th><th width="148">0 Reward</th><th>100% Reward</th><th width="142">Scale</th><th>Effective Time</th></tr></thead><tbody><tr><td><em>Online time</em></td><td><em>&#x3C;50% offline</em></td><td><em>100% online</em></td><td><em>Linear</em></td><td><em>2022</em></td></tr><tr><td><p>Effective <em>Satellite number</em></p><p><em>(SNR>32)</em></p></td><td>≤<em>26</em></td><td>≥<em>29</em></td><td><em>Linear</em></td><td><em>2022</em></td></tr><tr><td><em>Neighbor distance</em></td><td><em>&#x3C;100m</em></td><td><em>>100m</em></td><td><em>Split among miners, with exception of NFT holders</em></td><td><em>2023</em></td></tr><tr><td><em>Multipath</em></td><td>>0.75</td><td>-</td><td>-</td><td>2025 (Approved in GIP6)</td></tr><tr><td>GPS Signal Type</td><td>Dual band </td><td>Triple band</td><td>-</td><td>2025 (Approved in GIP6)</td></tr><tr><td>*<em>Data shift</em></td><td><em>>10cm</em> </td><td><em>&#x3C;2cm</em></td><td><em>Linear</em></td><td><mark style="color:red;">To be determined</mark></td></tr><tr><td>*<em>Latency</em></td><td><em>>5s</em></td><td><em>&#x3C;1s</em></td><td><em>Linear</em></td><td><mark style="color:red;">To be determined</mark></td></tr></tbody></table>

## Multipath (MP)

Multipath occurs when GNSS signals reflect off surfaces such as buildings, terrain, or infrastructure before reaching a receiver, causing GPS interference.

If you wish to learn more about multipath metrics from a technical perspective, you can read this [essay ](https://drive.google.com/file/d/1tXwuEnNVlHeKdfqnQN25fBZhjYS9aKl_/view?usp=sharing).&#x20;

#### **Why is Multipath a Problem?**

* Reduces Accuracy: The receiver detects both direct and reflected signals, leading to positioning errors.
* Impairs Performance: Delayed signal "echoes" distort calculations, degrading location precision.

#### **How Can You Reduce Multipath?**

Generally, if you set up your station following the[ installation guide](https://docs.geodnet.com/geod-mining/best-location-for-your-station), multipath is mitigated by the 10° rule. If you are unsure how to improve your station's performance, please reach out to our team on [Discord](https://discord.com/invite/geodnet) or via email at [support@geodnet.com](https://mailto:support@geodnet.com/).
