# The GEOD Mining Basics

### The GEODNET Network

The GEODNET network consists of satellite reference stations (known as base stations) that receive signals from Global Navigation Satellite Systems (GNSS). These stations correct signal errors caused by space weather, satellite inaccuracies, or urban obstructions.

Each station provides precise RTK correction data through the GEODNET network to devices within a 20–40 kilometer range. Devices that connect to GEODNET for enhanced accuracy are called "rovers." A rover can be any GNSS-enabled device, such as a car, drone, smartphone, or tractor.

Each station pploads \~10–20 GB of data and consumes <2W of power  per month.&#x20;

## Hex

In the GEODNET Network, regions of coverage are depicted by hexagons, also known as "hexes". There are many reasons why we use Hexes to map out coverage areas (if you want to take a deeper dive, Helium has a good explanation in [this article](https://blog.helium.com/mapping-the-world-with-hexagons-49f57d8b3df5?ref=blog.hellohelium.com)). Hexes allow us to maximize precision and proximity when mapping out the network.&#x20;

### The Mining Process

In order to build the largest reference station network, GEODNET designed a system where individuals can purchase and install a small geodetic-grade GNSS antenna (Base Station) on their roof to provide a node to the network — all over the world. As a reward for providing these reference points, individuals are rewarded with GEOD tokens.&#x20;

The Mining process is simple:

1. Purchase a Base Station
2. Install the station by connecting it to the internet to start sending data to GEODNET's Cloud Platform
3. Regiter your station on GEODNET [console](https://console.geodnet.com/) platform & add a wallet address
4. Earn GEOD Tokens

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FczpOXVxZk9xZqEA8pit3%2Fimage.png?alt=media&#x26;token=56db2044-8684-4740-bf33-913ec43e4490" alt=""><figcaption></figcaption></figure>
