# How to Configure Internet for Your Station

You can follow this [YouTube video](https://www.youtube.com/watch?v=TEkbqIQdlPE\&t=11s) or the content below to install your station.&#x20;

## 1. Start-up of the HYFIX device (HYFIX or OEM version)

### 1.1 Connect all Cables to the Base Station

Plug in the USB-C cable and power the HYFIX device with any 5 volt, 2.5 or 3 amp USB charger.

<div align="center"><figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FaL190gdIOcCSh9KY1T5W%2Fminer_poto_1.png?alt=media&#x26;token=36f6665e-e39c-4370-b9da-cf056347a157" alt=""><figcaption></figcaption></figure></div>

On the HYFIX device, remove the red plastic from the “WiFi-BT” input, and connect the Wi-Fi antenna.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FWXOaIVXXcCx7fS3UJkgE%2Fimage.png?alt=media&#x26;token=e878970f-7959-43f6-bd75-e045bd552455" alt="" width="375"><figcaption></figcaption></figure>

Remove the red plastic for “GNSS+” and connect the smaller end of the satellite antenna cable. (SMA-Male connector)

Connect the other end to the satellite antenna. (TNC-Male connector)

The "UWB" port is for future expansions and is currently not in use.&#x20;

### 1.2 Power UP / LED Definition

Switch your HYFIX unit to the ON position using the small slide switch.

The left <mark style="color:red;">red LED</mark> (Power) will turn on.

The right <mark style="color:green;">green LED</mark> (Wi-Fi Internet) should be blinking slowly.&#x20;

The middle <mark style="color:orange;">orange LED</mark> (PPS) will be off and activated later.&#x20;

The device is now in the “Access Point Mode” *(AP Mode).*

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FQoGtJtSId8xwXvPUeLbB%2Fminer_poto_4.png?alt=media&#x26;token=8b8daa7a-ec30-4d25-8516-f565e9022b9b" alt=""><figcaption></figcaption></figure>

*<mark style="color:red;">Note: We recommend using the provided Wi-Fi antenna, as we have observed issues during testing using random Wi-Fi antennas.</mark>*

<table data-header-hidden><thead><tr><th width="152"></th><th width="222"></th><th></th></tr></thead><tbody><tr><td><strong>LED</strong></td><td><strong>FUNCTION</strong></td><td><strong>STATUS</strong></td></tr><tr><td><mark style="color:red;">RED</mark></td><td>POWER</td><td>SOLID, when powered</td></tr><tr><td><mark style="color:orange;">ORANGE</mark></td><td>PPS (Pulse Per Second)</td><td>BLINKING (1s), antenna sees satellites</td></tr><tr><td><mark style="color:green;">GREEN</mark></td><td>Wi-Fi / Internet</td><td><p>BLINKING (SLOW): Access Point mode, used for configuring Internet connection (<mark style="color:blue;">http://192.168.4.1</mark>)</p><p> </p><p>BLINKING (FAST): Attempting to connect to Internet via Configured SSID and Password</p><p> </p><p>BLINKING (1 FAST and 1 SLOW) : WIFI is connected to router but not receiving any internet. (Router may be too far or router may be blocking internet from going to miner)</p><p></p><p>SOLID, Internet is connected</p></td></tr></tbody></table>

## 2. Wi-Fi Connection and Internet Setup

* Now using your phone, PC or MAC to connect to the HYFIX device's Wi-Fi.
* You don't need an internet connection for this step.
* On your phone, PC or MAC, go into the settings and networks and connect to your HYFIX device's Wi-Fi. It should start with “MGW200\_...” or "MobileCM\_...".
* For password, enter in the serial number that is on the back of your HYFIX device.
* Once connected, it may say, “no internet”, that’s okay.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FMUSnUpLAUBmpBrQZsiBG%2Fminer_poto_5.png?alt=media&#x26;token=e57c20bf-eb17-4ada-a055-f9ded4c6b2f8" alt=""><figcaption></figcaption></figure>

Turn over your HYFIX device and note the number on the sticker. You need this to register to the "console.geodnet.com" later on.

### 2.1 Configure MobileCM Network Connection (AP Mode)

Use the same device as in step 2.0, then enter the IP address 192.168.4.1 and this page will pop up. Some of our miners suggest that Firefox browser works better. \
For IOS or Mac device, setup page should pop up automatically after entering password.&#x20;

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2F8DuMzgnaJDDJgGtFnDKG%2Fimage.png?alt=media&#x26;token=6624e108-71cd-4a57-aba3-f30958f9332d" alt=""><figcaption></figcaption></figure>

<mark style="color:red;">**Miner Key:**</mark> <mark style="color:red;"></mark><mark style="color:red;">must be at least 12 characters long and contain no special characters.</mark>

If the green light starts flashing again, the Base Station has not been connected to Wi-Fi. Please check if you have connected it correctly and try again.

When the station gets a full green light, you can go over to your PC/Tablet that is connected to the same internet you connected your station to.

### 2.2 Open MobileCM WebUI (Station Mode)

* Now open your internet router’s webpage and check the current connected devices on your Wi-Fi.
* In the Router Settings you will find the MobileCM listed as: ***espressif.***
* Note the IP-Adress of ***espressif: 192.168.x.x.***
* You need to access on the MobileCM WebUI (Station Mode).

*<mark style="color:red;">Please be sure again you use 2.4GHZ Wi-Fi. (5GHz is not compatible with the MobileCM).</mark>*

*Go into your router settings, you do that through your web browser, by entering your routers own IP address.*

*Follow a link on how to find that for both windows and mac users:* [*https://www.howtogeek.com/233952/how-to-find-your-routers-ip-address-on-any-computer-* ](https://www.howtogeek.com/233952/how-to-find-your-routers-ip-address-on-any-computer-smartphone-or-tablet/)[*smartphone-or-tablet/*](https://www.howtogeek.com/233952/how-to-find-your-routers-ip-address-on-any-computer-smartphone-or-tablet/)

*If you live in an apartment with shared Wi-Fi, and you have problems with this, you can just call your internet provider and ask them for help. And you ask them the same thing that you will be looking for inside the router settings. “You are looking for the IP address of a device named espressif”.*

* When you have the IP address (IP 192.168).x.x enter it into your browser, and this page should pop up.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FGLFI0VvusGvD8YPMuJZi%2Fimage.png?alt=media&#x26;token=255f5bfd-d2d1-4b22-ad19-8688c2aff43d" alt="" width="563"><figcaption></figcaption></figure>

### 2.3 Set Miner Key and Transmit Data to GEODNET

If you see the word “TRANSMITTNG”, the setup is complete.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FIa4Hy9elkRIESGrcaT6o%2Ffb9d67e6e90c816ec8ccd21443efc10.png?alt=media&#x26;token=3e036bf9-3447-4356-8d5a-c6fa0a8026db" alt=""><figcaption></figcaption></figure>

**Useful information if you change location or have made a mistake in setup:**

For those interested, pressing the “reset” key on the back resets the device back to AP-Mode. Then, proceed with the basic setup again to update to the new Wi-Fi.

This is really useful when moving locations.

Please double check your Wi-Fi name and password was entered correctly.

If it fails to connect due to mistakes in password or network name, please try again.

### 2.4 Access the MobileCM Station on the Console.Geodnet.com

Turn over your HYFIX device and note the number on the sticker. You need this to access the Console platform at[ console.geodnet.com.](https://console.geodnet.com/)

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FMUSnUpLAUBmpBrQZsiBG%2Fminer_poto_5.png?alt=media&#x26;token=e57c20bf-eb17-4ada-a055-f9ded4c6b2f8" alt=""><figcaption></figcaption></figure>
