# Hex Reward Rules

The Hex reward rules are designed to encourage even coverage of the GEODNET network.

### Miner Reward in Hex

1. The Base Station (Satellite Miner) with NFT in a Hex has no penalty, so the reward multiplier is 100%.

**Note:** If there is no NFT station within the Hex,  stations without NFT status share 100%.  For example, reward multiplier for 1 non-NFT station is 100%, 50% each for 2 non-NFT stations in the Hex.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FdBQRdyH2wCKmpjHTr6MC%2Fimage.png?alt=media&#x26;token=2feddc72-d042-460d-81ad-e7a1002ac5a3" alt=""><figcaption></figcaption></figure>

2. All other stations in the same hex without NFT share another 100%.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FXNlzBSRRU8htNCXAXaLj%2Fimage.png?alt=media&#x26;token=724245af-52e2-461b-9a55-5a8c397e1176" alt=""><figcaption></figcaption></figure>

3. Distance within 100m will share one reward no matter how many Base Stations are within a 100m distance.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FQemEq4By0fLKYGcfhilS%2Fimage.png?alt=media&#x26;token=6d56aa0e-8c4a-4867-985f-4044d6d3c293" alt=""><figcaption></figcaption></figure>

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FdcvbG8xNDa8BNFXQNF1q%2Fimage.png?alt=media&#x26;token=ed197569-0b85-4b9a-b6cc-157ee24e41e4" alt=""><figcaption></figcaption></figure>

Explanation:&#x20;

*If there is one NFT Base Station and two normal Base Stations in the field, the NFT station gets 100%, and the other two share 100% with 50% each. Total 200% in the field.*

*If there are two NFT Base Stations and two normal Base Stations in the field, each NFT station gets 100%, and the other two share 100% with 50% each. A total of 300% in the field.*&#x20;

**Note:** Prior to April 1, 2023, GEODNET issued Location NFTs to all Base Stations that maintained a 30-day RRR exceeding 98% as a reward for early adoption. As of April 1, 2023, only the first eligible Base Station in a hex will receive a Location NFT. Within a hex with multiple stations, only stations with the NFT are eligible for full rewards. The other Base Stations will split the remaining eligible rewards.&#x20;

4. For a cluster of  Base Stations within 100m, only the earliest station gets the cluster share. All other stations get zero regardless of NFT status.&#x20;

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FsUDNcDyCstIz2iRf78Lr%2Fimage.png?alt=media&#x26;token=255938e4-922b-4037-8957-08dcf2c7b1a2" alt=""><figcaption></figcaption></figure>

### NFT Miners Within 100m in a Hex

If two NFT Base Stations are in the same spot, only one will get the full reward. The other gets zero.

This rule proceeds the NFT benefit, which means even if both Base Stations have NFT, only one will get the full reward, the other one will get zero.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FSab186EaxRfgdmSQ3fa6%2Fimage.png?alt=media&#x26;token=45381a18-9fbf-4b12-bc51-562fec54768d" alt=""><figcaption></figcaption></figure>

### Edge Cases

1. After April 1, 2023, you may occasionally see two NFT miners within the same Hex. This happens when both miners meet the NFT criteria on the same day when our system performs a check.
2. As of July 15, 2025, if two stations meet the NFR criteria on the same day within the same hex, only the station installed earlier (based on timestamp) can earn the NFT
3. If there is already an NFT miner within a Hex, and another NFT miner attempts to move to the same Hex, the NFT status of the latter miner will be invalidated.

### Miners Inactive&#x20;

If a Base Station without NFT is offline for 7 days, it will not be counted as an active station in a Hex. So, its previous share of the reward will be reduced to zero.

If a Base Station with NFT is offline for 30+7 days, it will not be counted as an active station in a Hex. It will lose its NFT-protected position. Its previous share of the reward will be reduced to zero. Other Miners in the same hex thus can bind an NFT afterward.

### Miner Reward Re-calculation&#x20;

The Miner reward multiplier will be recalculated within a Hex when the following behavior happens:

1\) New Base Stations are added into the Hex&#x20;

2\) Base Stations leave the Hex

3\) Unbinding NFT successful&#x20;

4\) Binding new NFT successful

5\) If the Base Station (no NFT) is offline for more than 7 days.

6\) If the Base Station (with NFT) is offline for more than 30+7 days.

### Moving Stations Between Different Hexes

The rules below are implemented on October 9th, 2024, as a result of the successful passing of [GIP2:](https://vote.geodnet.com/proposal-list?id=GIP695741716474622802)&#x20;

1. Miners' RRR will reset to 0% upon any Hex change.
2. NFTs will be unbound for any Hex change, with re-binding allowed only after achieving a 98% RRR over 30 days.
3. Location changes within the same Hex will not trigger an RRR reset.

&#x20;
