# SuperHex

### What is SuperHex

The GEODNET Foundation is working with the community to build a worldwide, evenly distributed RTK network. Achieving even coverage requires deployment in less populated regions and some hard-to-reach locations. The GEODNET Foundation launched the SuperHex program to promote better coverage even in remote areas.

The GEODNET Foundation, together with current and potential customers, reviews a list of high value areas on the map requiring RTK base stations. These regions are then defined as a SuperHex. The SuperHex consists of 7 continuous subhexes in the current GEODNET network map. The Foundation makes these SuperHexes stakable. All community GEOD holders can stake on these SuperHexes. Afterwards, existing and future miners can deploy a Base Station in the SuperHexes to receive additional rewards.

The GEODNET Foundation has successfully launched both Phase I and Phase II SuperHex programs.&#x20;

### Comparison of SuperHex Phase I and Phase II

<table><thead><tr><th width="281.3333333333333">Comparison</th><th>Phase I</th><th>Phase II</th></tr></thead><tbody><tr><td>GEOD needed to activate SuperHex</td><td>50,000 GEOD</td><td>20,000 GEOD</td></tr><tr><td>Number of SuperHex</td><td>91</td><td>Up to 500</td></tr><tr><td>Number of Spots with multiplier rewards</td><td>3</td><td>1</td></tr><tr><td>Minimal GEOD stake</td><td>2000 GEOD</td><td>1000 GEOD</td></tr><tr><td>Staked GEOD reward</td><td>10%</td><td>20%</td></tr><tr><td>Max multiplier</td><td><p>Incremental up to</p><p>14x</p></td><td>Fixed 2x or 4x</td></tr><tr><td>Launch date</td><td>Nov 2023</td><td>Apr 2024</td></tr></tbody></table>

### Claiming & Retaining Phase II SuperHex Rewards&#x20;

Prior to the implementation of [GIP5](https://vote.geodnet.com/proposal-list?id=GIP202381733411309930), the first newly deployed GNSS Base Station within an active SuperHex will receive rewards multiplied by up to 4x.

GIP5 was implemented on January 09, 2025 which amended the rules for claiming and retaining multiplied rewards in an active SuperHex. \
\
**Claiming SuperHex Multiplied Rewards:**

The first station by timestamp (no ties) that reaches a 7-day RRR of ≥95% will take the open SuperHex spot and thus the bonus multiplier for that Superhex. If two stations hit ≥95% at the same time, the station with the earlier install time will be awarded the open SuperHex Spot.

**Retaining SuperHex Multiplied Rewards:**&#x20;

A station that currently holds the SuperHex spot will lose it if their 14-day RRR drops below 84%. This check will occur 14 days after the station first receives the SuperHex spot.&#x20;

The next station in the SuperHex with a 7-day RRR of ≥95% will then be awarded the SuperHex bonus multiplier. If multiple stations qualify, the station with the highest 7-day RRR in the SuperHex will be awarded the bonus multiplier. In the event of an RRR tie, the station with the earlier install timestamp in the SuperHex will be awarded the multiplier.

**Losing Superhex Rewards:**

1. Station unregistered from GEODNET console platform&#x20;
2. Station moves out of SuperHex area
3. Station's 14-day RRR value is less than 84% (New rule under GIP5)

### Staking Workflow

Key Steps of the staking process include:

1. GEODNET creates a SuperHex proposal and makes it available to stake.
2. All users can stake GEOD tokens to meet the minimal requirements (20,000 GEOD currently) within 90 days. The proposed SuperHex becomes active for station deployment.
3. Within 180 days, the initial station deployed in the designated SuperHex area will receive multiplier rewards for a duration of one year starting from the installation date of the station.
4. Stakers will get 20% percent bonus at the end of the 1-year period for staked GEOD tokens.

### States of SuperHex

A SuperHex can have three states:&#x20;

**Available for staking (Proposal):** The GEODNET foundation creates a new proposed SuperHex location for the community to stake. Users connect their wallet to stake the available SuperHex. The minimum stake required is 1000 GEOD, with increments of 1000 GEOD thereafter.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FDcJlf4rGq9eYFECH1gmC%2Fimage.png?alt=media&#x26;token=d98e0a04-3ee0-4d69-82bc-fa42abc8e3ea" alt=""><figcaption><p>Available for Staking SuperHex</p></figcaption></figure>

**Active:** Once a SuperHex is fully staked, the color of SuperHex changes to blue. For each Active SuperHex, the console will clealy indicate whether the SuperHex has a 2X or 4X 1-year multiplier.&#x20;

Anyone in the SuperHex region can then deploy a new Base Station in one of the 7 hexes and start to earn extra rewards! Most of the SuperHex reward is set to 2X the average miner reward. In some extremely valuable locations, the SuperHex reward can be up to 4x the average miner reward. At the end of 180 days, if no miner appears in a SuperHex, the SuperHex becomes No-show and the staked tokens are released back to the stakers without the Phase II 20% bonus.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2Fvai6QC4YjevVw9QBx9qW%2Fimage.png?alt=media&#x26;token=fa6bc433-b177-45dc-86f1-033f4d2606d8" alt=""><figcaption><p>Active SuperHex</p></figcaption></figure>

**Producing:** The icon for the SuperHex will show a red check mark. The first deployed Base Station receives the multiplied rewards. Any following Base Station installed in the SuperHex will then receive the normal 1x reward. All subsequent stations are subject to regular rules such as overcrowding penalty, NFT protection, etc.

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2F50JCbh5Nwhkg08sqyMie%2Fimage.png?alt=media&#x26;token=2ba9d1bb-482a-49c3-a4eb-88dc61727c47" alt=""><figcaption><p>Producing SuperHex</p></figcaption></figure>

**SuperHex State Change Diagram:**&#x20;

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2Fj4JcFg22nYw4AYpIfWw6%2Fimage.png?alt=media&#x26;token=e5a49fa6-fca3-4ada-961b-c363ece1f016" alt=""><figcaption></figcaption></figure>

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FhYQ5kQqGn9QTKynpbBk6%2Fimage.png?alt=media&#x26;token=e7c7843e-b448-41b6-8da1-f3586afb21ae" alt=""><figcaption></figcaption></figure>
