# Location NFT Use&#x20;

### One Per Hex Rule

The GEOD Location NFT is an ERC-721 token used by the GEODNET community to incentivize highly active miners. The Location NFT is awarded to the first high-performance Base Station installed in a GEODNET Hex. A new batch of GEODNET NFTs is sent to the newly-qualified Base Stations’ wallet addresses on file on a daily basis during work days.&#x20;

To qualify, the Base Station must receive 98% or more of the eligible rewards for a 30-day period, and it must be the first Base Station in the hex to do so. This metric is known as the Rolling Rewards Rate (RRR), and it is prominently displayed on the console.

To reach the 98% threshold, the installation of Base Station needs to be optimal and the online rate needs to be very close to perfect. However, with a clear view sky and a stable connection, this is easily achievable.&#x20;

<figure><img src="https://1198063627-files.gitbook.io/~/files/v0/b/gitbook-x-prod.appspot.com/o/spaces%2F17b3S6vQzTmJA9I9ddAG%2Fuploads%2FI4vSIVjsfcdxhbYmyZ7x%2Flnft01.png?alt=media&#x26;token=82ad4c2a-0281-4514-9841-c0d14dafb1e0" alt=""><figcaption><p>Image from GEODNET Console Showing the Rolling Rewards Rate</p></figcaption></figure>

**Note:** Prior to April 1, 2023, GEODNET issued Location NFTs to all Base Stations that maintained a 30-day RRR exceeding 98% as a reward for early adoption. As of April 1, 2023, only the first eligible Base Station in a hex will receive a Location NFT. Within a hex with multiple stations, only stations with the NFT are eligible for full rewards. The other Base Stations will split the remaining eligible rewards.&#x20;

### NFT Protection in Crowded Hexes

In a crowded hex with multiple Base Stations, only the station with a Location NFT is eligible to receive the full rewards rate. The other Base Stations will split eligible rewards.

For hexes where multiple Location NFTs were rewarded prior to April 1, 2023, all the Location NFT holders in that hex are eligible for the maximum reward rate.

### What If My RRR Later Drops

If your Base Station has an NFT, but the station's RRR later drops, the miner does not lose the Location NFT. However, the rewards rate will decrease in accordance with the current station performance. In other words, the Location NFT does not guarantee rewards, it merely ensures eligibility for the maximum rewards.

### Future Benefits of Location NFT

Miners with the GEOD Location NFTs also have additional community privileges, such as proposing and voting on proposals in Governance. In the future, Location NFT holders will have further priority participation rights in GEODNET community governance.
